VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form Form1 
   Caption         =   "KPCI-PDISO8A Board"
   ClientHeight    =   6105
   ClientLeft      =   1800
   ClientTop       =   1695
   ClientWidth     =   9120
   LinkTopic       =   "Form1"
   ScaleHeight     =   6105
   ScaleWidth      =   9120
   Begin VB.CommandButton Command1 
      Caption         =   "Read digital input port with external interrupt"
      Height          =   855
      Left            =   1553
      TabIndex        =   7
      Top             =   2280
      Width           =   1455
   End
   Begin VB.TextBox Text1 
      Alignment       =   2  'Center
      Height          =   285
      Left            =   4193
      TabIndex        =   6
      Text            =   "Text1"
      Top             =   3360
      Width           =   735
   End
   Begin VB.ListBox List1 
      BeginProperty DataFormat 
         Type            =   1
         Format          =   "0"
         HaveTrueFalseNull=   0
         FirstDayOfWeek  =   0
         FirstWeekOfYear =   0
         LCID            =   1033
         SubFormatType   =   1
      EndProperty
      Height          =   450
      ItemData        =   "KPCIPDISO8A.frx":0000
      Left            =   1793
      List            =   "KPCIPDISO8A.frx":0002
      TabIndex        =   5
      Top             =   3277
      Width           =   975
   End
   Begin VB.CommandButton Command2 
      Caption         =   "Read digital input port A below"
      Height          =   855
      Left            =   3833
      TabIndex        =   4
      Top             =   2280
      Width           =   1455
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Write to digital output port A` below"
      Height          =   855
      Left            =   6113
      TabIndex        =   3
      Top             =   2280
      Width           =   1455
   End
   Begin VB.TextBox Text2 
      Alignment       =   2  'Center
      Height          =   285
      Left            =   6353
      TabIndex        =   2
      Text            =   "Value"
      Top             =   3360
      Width           =   975
   End
   Begin DlsrLib.DriverLINXSR SRDO 
      Left            =   0
      Top             =   720
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXLDD LDD 
      Left            =   0
      Top             =   1320
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin DlsrLib.DriverLINXSR SRDI 
      Left            =   0
      Top             =   120
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label2 
      Caption         =   $"KPCIPDISO8A.frx":0004
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   855
      Left            =   1080
      TabIndex        =   1
      Top             =   4560
      Width           =   6975
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      BackColor       =   &H0000FF00&
      Caption         =   "ERRORS / MESSAGES"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1335
      Left            =   2453
      TabIndex        =   0
      Top             =   360
      Width           =   4215
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'For KPCI-PDISO8A logical channel 0 (A)is input
'For KPCI-PDISO8A logical channel 1 (A`) is output

Option Explicit
Dim array0(1) As Byte
Dim result As Long
Dim n, chan As Integer

Private Sub Command1_Click()
With SRDI
'Reads channel 0 on external interrupts
'Ground pins 3 and 21
'Connect external interrupt to pins 4 and 22
.Req_subsystem = DL_DI
.Req_mode = DL_INTERRUPT
.Req_op = DL_START
.Evt_Str_type = DL_COMMAND
.Evt_Stp_type = DL_TCEVENT
.Evt_Tim_type = DL_RATEEVENT
.Evt_Tim_rateChannel = 0
.Evt_Tim_rateClock = DL_EXTERNAL
.Evt_Tim_rateGate = DL_NOCONNECT
.Evt_Tim_rateMode = DL_RATEGEN
.Evt_Tim_ratePeriod = .DLSecs2Tics(DL_DEFAULTTIMER, 1 / 100)
.Sel_chan_format = DL_tNATIVE
.Sel_chan_N = 1
.Sel_chan_start = 0         'start sampling at logical ch 0
.Sel_chan_startGainCode = 0
.Sel_buf_samples = 1
.Sel_buf_N = 1
.Sel_buf_notify = DL_NOTIFY
.Refresh
End With
ShowMessage SRDI, "Waiting for external interrupt......"
End Sub

Private Sub Command2_Click()
With SRDI
'Reads channel 0 without external interrupts
.Req_subsystem = DL_DI
.Req_mode = DL_POLLED
.Req_op = DL_START
.Evt_Str_type = DL_NULLEVENT
.Evt_Tim_type = DL_NULLEVENT
.Evt_Stp_type = DL_NULLEVENT
.Sel_buf_N = 0
.Sel_chan_N = 1
.Sel_chan_format = DL_tNATIVE
.Sel_chan_start = 0     'samples logical channel 0
.Refresh
Text1.Text = .Res_Sta_ioValue
End With
ShowMessage SRDI, "Channel read"
End Sub

Private Sub Command3_Click()
Dim DOValue  As Byte
On Error GoTo EnterNumber
DOValue = CByte(Text2.Text)
With SRDO
.Req_subsystem = DL_DO
.Req_mode = DL_POLLED
.Req_op = DL_START
.Evt_Str_type = DL_NULLEVENT
.Evt_Stp_type = DL_NULLEVENT
.Evt_Tim_type = DL_NULLEVENT
.Sel_chan_format = DL_tNATIVE
.Sel_chan_N = 1
.Sel_chan_start = 1     'send output to logical channel 1
.Sel_buf_N = 0
.Res_Sta_ioValue = DOValue
.Refresh
End With
ShowMessage SRDO, "Value sent to digital output port"
Exit Sub  ' by pass the error handler
EnterNumber:
MsgBox "Please enter a numeric Value between 0 and 255", vbOKOnly
End Sub

Private Sub SRDI_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)
result = SRDI.VBArrayBufferXfer(0, array0, DL_BufferToVBArray)
List1.Clear
For n = 0 To 0
List1.AddItem (Str(array0(n)) And &H3F) & " ,  " & "CH " & Str(n)
Next n
ShowMessage SRDI, "Channel read"
' mask with a &h3F since the upper two bits are not really inputs....
' they are used for interrupt enable and interrupt request
End Sub

Private Sub Form_Load()
With SRDI
.Req_DLL_name = "kpciiso$"  ' the $ means load only the kcpiiso driver
.Req_device = 0
.Req_subsystem = DL_DEVICE
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Refresh
End With

If SRDI.Res_result = DL_NoErr Then
LDD.Req_DLL_name = SRDI.Req_DLL_name
LDD.device = SRDI.Req_device
LDD.Refresh
Form1.Caption = "Direct I/O COM API with " & LDD.Dev_Model
End If

With SRDO
.Req_DLL_name = SRDI.Req_DLL_name
.Req_device = SRDI.Req_device
.Req_subsystem = DL_DEVICE
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Refresh
End With
ShowMessage SRDI, "Board initialized"
End Sub

Sub ShowMessage(SR As Control, status As String) 'Error handling routine
If SR.Res_result <> 0 Then
Label1.Caption = SR.Message
Else
Label1.Caption = status
End If
End Sub

Private Sub Form_Unload(Cancel As Integer)
' unload the drivers for each object
SRDI.Req_DLL_name = ""
SRDO.Req_DLL_name = ""
LDD.Req_DLL_name = ""
End Sub

